/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.milter.trace;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Properties;

import org.apache.james.mime4j.dom.Message;

import net.bluemind.common.telemetry.EmailTracer;
import net.bluemind.milter.IMilterListener;
import net.bluemind.milter.IMilterListenerFactory;
import net.bluemind.milter.SmtpEnvelope;
import net.bluemind.milter.Status;

public class OpenTelemetryTrace implements IMilterListener {

	public OpenTelemetryTrace() {
		// ok
	}

	@Override
	public Status onMessage(Properties properties, SmtpEnvelope envelope, Message message) {
		Optional.ofNullable(message.getHeader().getField(EmailTracer.TRACE_HEADER_NAME)).ifPresent(field -> {
			EmailTracer.trace("milter", field.getBody(), message.getMessageId(), message.getSubject());
		});
		return Status.getContinue();
	}

	@Override
	public Status onHeader(String headerf, String headerv) {
		return Status.getContinue();
	}

	@Override
	public Status onBody(ByteBuffer body) {
		return Status.getContinue();
	}

	@Override
	public Status onEnvFrom(Properties properties, String from) {
		return Status.getContinue();
	}

	@Override
	public Status onEnvRcpt(Properties properties, String rcpt) {
		return Status.getContinue();
	}

	@Override
	public Status onEoh() {
		return Status.getContinue();
	}

	public static class Factory implements IMilterListenerFactory {
		public Factory() {
			// ok
		}

		@Override
		public IMilterListener create() {
			return new OpenTelemetryTrace();
		}

	}
}