/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
TodoListClient._rpcClient;

/**
 * URL
 */
TodoListClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
TodoListClient.prototype._containerUid;

/**
 * @constructor
 */ 
function TodoListClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/todolist/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

TodoListClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
TodoListClient.prototype.all = function() {
  let url = this._baseUrl;


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.allUids = function() {
  let url = this._baseUrl + "/_all";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.changeset = function( since  ) {
  let url = this._baseUrl + "/_changeset";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.changesetById = function( since  ) {
  let url = this._baseUrl + "/_changesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.copy = function( uids ,  destContainerUid  ) {
  let url = this._baseUrl + "/_copy/{destContainerUid}";

  url = url.replace("{destContainerUid}", destContainerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.count = function( arg0  ) {
  let url = this._baseUrl + "/_count";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.create = function( uid ,  todo  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = todo;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.createById = function( id ,  arg1  ) {
  let url = this._baseUrl + "/id/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.deleteById = function( id  ) {
  let url = this._baseUrl + "/id/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.filteredChangesetById = function( since ,  arg1  ) {
  let url = this._baseUrl + "/_filteredChangesetById";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.getByIcsUid = function( uid  ) {
  let url = this._baseUrl + "/_icsuid/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.getCompleteById = function( id  ) {
  let url = this._baseUrl + "/{id}/completeById";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.getVersion = function() {
  let url = this._baseUrl + "/_version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.itemChangelog = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/{uid}/_itemchangelog";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.move = function( uids ,  destContainerUid  ) {
  let url = this._baseUrl + "/_move/{destContainerUid}";

  url = url.replace("{destContainerUid}", destContainerUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.multipleDeleteById = function( arg0 ,  bypassDeletedItems  ) {
  let url = this._baseUrl + "/_multipleDelete";


  url += "?bypassDeletedItems=" + encodeURIComponent(bypassDeletedItems);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.multipleGet = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.multipleGetById = function( arg0  ) {
  let url = this._baseUrl + "/_mgetById";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.reset = function() {
  let url = this._baseUrl + "/_reset";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.search = function( query  ) {
  let url = this._baseUrl + "/_search";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.sortedIds = function( arg0  ) {
  let url = this._baseUrl + "/_sorted";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.sortedUids = function( arg0  ) {
  let url = this._baseUrl + "/_sorteduids";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg0;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.sync = function( since ,  changes  ) {
  let url = this._baseUrl + "/_sync";


  url += "?since=" + encodeURIComponent(since);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = changes;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.update = function( uid ,  todo  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = todo;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.updateById = function( id ,  arg1  ) {
  let url = this._baseUrl + "/id/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
TodoListClient.prototype.updates = function( changes  ) {
  let url = this._baseUrl + "/_mupdates";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = changes;
  return this._execute(cmd, body);
};

TodoListClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
