/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
ServerClient._rpcClient;

/**
 * URL
 */
ServerClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
ServerClient.prototype._containerUid;

/**
 * @constructor
 */ 
function ServerClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/servers/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

ServerClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
ServerClient.prototype.allComplete = function() {
  let url = this._baseUrl + "/_complete";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.assign = function( serverUid ,  domainUid ,  tag  ) {
  let url = this._baseUrl + "/{domainUid}/assignments/{serverUid}/_assign";

  url = url.replace("{serverUid}", serverUid);
  url = url.replace("{domainUid}", domainUid);

  url += "?tag=" + encodeURIComponent(tag);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.byAssignment = function( domainUid ,  tag  ) {
  let url = this._baseUrl + "/{domainUid}/byAssignment";

  url = url.replace("{domainUid}", domainUid);

  url += "?tag=" + encodeURIComponent(tag);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.create = function( uid ,  srv  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = srv;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.getAssignments = function( domainUid  ) {
  let url = this._baseUrl + "/{domainUid}/assignments";

  url = url.replace("{domainUid}", domainUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.getServerAssignments = function( uid  ) {
  let url = this._baseUrl + "/{uid}/serverAssignments";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.getStatus = function( uid ,  ref  ) {
  let url = this._baseUrl + "/{uid}/command_status";

  url = url.replace("{uid}", uid);

  url += "?ref=" + encodeURIComponent(ref);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.readFile = function( uid ,  path  ) {
  let url = this._baseUrl + "/{uid}/fs/{path}";

  url = url.replace("{uid}", uid);
  url = url.replace("{path}", path);

  let responseType = "";
  responseType = "arraybuffer";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.setTags = function( uid ,  tags  ) {
  let url = this._baseUrl + "/{uid}/tags";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = tags;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.submit = function( uid ,  argv  ) {
  let url = this._baseUrl + "/{uid}/submit_command";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = argv;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.submitAndWait = function( uid ,  argv  ) {
  let url = this._baseUrl + "/{uid}/submit_command_and_wait";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = argv;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.unassign = function( serverUid ,  domainUid ,  tag  ) {
  let url = this._baseUrl + "/{domainUid}/assignments/{serverUid}/_unassign";

  url = url.replace("{serverUid}", serverUid);
  url = url.replace("{domainUid}", domainUid);

  url += "?tag=" + encodeURIComponent(tag);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.update = function( uid ,  srv  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = srv;
  return this._execute(cmd, body);
};

/*
 *
 */
ServerClient.prototype.writeFile = function( uid ,  path ,  content  ) {
  let url = this._baseUrl + "/{uid}/fs/{path}";

  url = url.replace("{uid}", uid);
  url = url.replace("{path}", path);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = content;
  return this._execute(cmd, body);
};

ServerClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
