/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
MailboxesClient._rpcClient;

/**
 * URL
 */
MailboxesClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
MailboxesClient.prototype._domainUid;

/**
 * @constructor
 */ 
function MailboxesClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/mailboxes/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

MailboxesClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
MailboxesClient.prototype.addDomainRule = function( rule  ) {
  let url = this._baseUrl + "/_rules";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = rule;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.addMailboxRule = function( mailboxUid ,  rule  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = rule;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.addMailboxRuleRelative = function( mailboxUid ,  position ,  anchorId ,  rule  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules/{position}/{anchorId}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{position}", position);
  url = url.replace("{anchorId}", anchorId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = rule;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byEmail = function( email  ) {
  let url = this._baseUrl + "/_byemail";


  url += "?email=" + encodeURIComponent(email);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byName = function( name  ) {
  let url = this._baseUrl + "/_byname";


  url += "?name=" + encodeURIComponent(name);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.byRouting = function( email  ) {
  let url = this._baseUrl + "/_byRouting";


  url += "?email=" + encodeURIComponent(email);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.create = function( uid ,  mailbox  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = mailbox;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.deleteDomainRule = function( id  ) {
  let url = this._baseUrl + "/_rules/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.deleteMailboxRule = function( mailboxUid ,  id  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules/{id}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getDomainFilter = function() {
  let url = this._baseUrl + "/_filter";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getDomainRule = function( id  ) {
  let url = this._baseUrl + "/_rules/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getDomainRules = function() {
  let url = this._baseUrl + "/_rules";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxAccessControlList = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_acls";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxConfig = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_config";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxDelegationRule = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_delegationRule";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxFilter = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_filter";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxForwarding = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_forwarding";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxQuota = function( uid  ) {
  let url = this._baseUrl + "/{uid}/_quota";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxRule = function( mailboxUid ,  id  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules/{id}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxRules = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxRulesByClient = function( mailboxUid ,  client  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rulesByClient";

  url = url.replace("{mailboxUid}", mailboxUid);

  url += "?client=" + encodeURIComponent(client);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getMailboxVacation = function( mailboxUid  ) {
  let url = this._baseUrl + "/{mailboxUid}/_vacation";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.getUnreadMessagesCount = function() {
  let url = this._baseUrl + "/_unread";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.list = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.listUids = function() {
  let url = this._baseUrl + "/_listUids";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.moveMailboxRule = function( mailboxUid ,  id ,  direction  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules/{id}/{direction}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{id}", id);
  url = url.replace("{direction}", direction);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.moveMailboxRuleRelative = function( mailboxUid ,  id ,  position ,  anchorId  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules/{id}/{position}/{anchorId}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{id}", id);
  url = url.replace("{position}", position);
  url = url.replace("{anchorId}", anchorId);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.multipleGet = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setDomainFilter = function( filter  ) {
  let url = this._baseUrl + "/_filter";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = filter;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxAccessControlList = function( mailboxUid ,  accessControlEntries  ) {
  let url = this._baseUrl + "/{mailboxUid}/_acls";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = accessControlEntries;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxDelegationRule = function( mailboxUid ,  delegationRule  ) {
  let url = this._baseUrl + "/{mailboxUid}/_delegationRule";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = delegationRule;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxFilter = function( mailboxUid ,  filter  ) {
  let url = this._baseUrl + "/{mailboxUid}/_filter";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = filter;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxForwarding = function( mailboxUid ,  forwarding  ) {
  let url = this._baseUrl + "/{mailboxUid}/_forwarding";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = forwarding;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.setMailboxVacation = function( mailboxUid ,  vacation  ) {
  let url = this._baseUrl + "/{mailboxUid}/_vacation";

  url = url.replace("{mailboxUid}", mailboxUid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = vacation;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.update = function( uid ,  mailbox  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = mailbox;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.updateDomainRule = function( id ,  rule  ) {
  let url = this._baseUrl + "/_rules/{id}";

  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = rule;
  return this._execute(cmd, body);
};

/*
 *
 */
MailboxesClient.prototype.updateMailboxRule = function( mailboxUid ,  id ,  rule  ) {
  let url = this._baseUrl + "/{mailboxUid}/_rules/{id}";

  url = url.replace("{mailboxUid}", mailboxUid);
  url = url.replace("{id}", id);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = rule;
  return this._execute(cmd, body);
};

MailboxesClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
