/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
InstallationClient._rpcClient;

/**
 * URL
 */
InstallationClient._baseUrl;

/**
 * @constructor
 */ 
function InstallationClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/system/installation';
  
};

InstallationClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
InstallationClient.prototype.clone = function( sourceParams  ) {
  let url = this._baseUrl + "/_clone";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = sourceParams;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.deleteLogo = function() {
  let url = this._baseUrl + "/logo";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.demoteLeader = function() {
  let url = this._baseUrl + "/state/_demote";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getHostReport = function() {
  let url = this._baseUrl + "/_hostReport";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getInfos = function() {
  let url = this._baseUrl + "/_infos";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getLogo = function() {
  let url = this._baseUrl + "/logo";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getSubscriptionContacts = function() {
  let url = this._baseUrl + "/_subscriptionContacts";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getSubscriptionInformations = function() {
  let url = this._baseUrl + "/subscription";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getSubscriptionKind = function() {
  let url = this._baseUrl + "/subscriptionKind";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getSystemState = function() {
  let url = this._baseUrl + "/state";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.getVersion = function() {
  let url = this._baseUrl + "/version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.initialize = function() {
  let url = this._baseUrl + "/_initialize";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.isValidProductionSubscription = function() {
  let url = this._baseUrl + "/subscriptionProductiveValid";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.maintenanceMode = function() {
  let url = this._baseUrl + "/state/_maintenance";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.markSchemaAsUpgraded = function() {
  let url = this._baseUrl + "/version";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.ping = function( ip  ) {
  let url = this._baseUrl + "/{ip}/ping";

  url = url.replace("{ip}", ip);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.postinst = function() {
  let url = this._baseUrl + "/_postinst";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.promoteLeader = function() {
  let url = this._baseUrl + "/state/_promote";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.removeSubscription = function() {
  let url = this._baseUrl + "/subscription";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.resetIndex = function( index  ) {
  let url = this._baseUrl + "/{index}/_resetIndex";

  url = url.replace("{index}", index);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.resetIndexes = function() {
  let url = this._baseUrl + "/_resetIndexes";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.runningMode = function() {
  let url = this._baseUrl + "/state/_maintenance";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.sendHostReport = function() {
  let url = this._baseUrl + "/_hostReport";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.setLogo = function( logo  ) {
  let url = this._baseUrl + "/logo";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = logo;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.setSubscriptionContacts = function( emails  ) {
  let url = this._baseUrl + "/_subscriptionContacts";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = emails;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.updateSubscription = function( licence  ) {
  let url = this._baseUrl + "/subscription";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = licence;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.updateSubscriptionVersion = function( version  ) {
  let url = this._baseUrl + "/subscription/_version";


  url += "?version=" + encodeURIComponent(version);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.updateSubscriptionWithArchive = function( archive  ) {
  let url = this._baseUrl + "/subscription/_archive";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = archive;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.upgrade = function() {
  let url = this._baseUrl + "/_upgrade";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
InstallationClient.prototype.upgradeStatus = function() {
  let url = this._baseUrl + "/_upgrade";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

InstallationClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
