/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
GroupClient._rpcClient;

/**
 * URL
 */
GroupClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
GroupClient.prototype._domainUid;

/**
 * @constructor
 */ 
function GroupClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/groups/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

GroupClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
GroupClient.prototype.add = function( uid ,  members  ) {
  let url = this._baseUrl + "/{uid}/members";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = members;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.allUids = function() {
  let url = this._baseUrl + "/_alluids";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.byEmail = function( email  ) {
  let url = this._baseUrl + "/byEmail/{email}";

  url = url.replace("{email}", email);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.byName = function( name  ) {
  let url = this._baseUrl + "/byName/{name}";

  url = url.replace("{name}", name);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.create = function( uid ,  group  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = group;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.createWithExtId = function( uid ,  extid ,  group  ) {
  let url = this._baseUrl + "/{uid}/{extid}/createwithextid";

  url = url.replace("{uid}", uid);
  url = url.replace("{extid}", extid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = group;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.delete_ = function( uid  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.get = function( uid  ) {
  let url = this._baseUrl + "/{uid}";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  body = uid;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getByExtId = function( extid  ) {
  let url = this._baseUrl + "/_extid/{extid}";

  url = url.replace("{extid}", extid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getComplete = function( uid  ) {
  let url = this._baseUrl + "/{uid}/complete";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getExpandedMembers = function( uid  ) {
  let url = this._baseUrl + "/{uid}/expandedmembers";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getExpandedUserMembers = function( uid  ) {
  let url = this._baseUrl + "/{uid}/expandedusersmembers";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getGroupsWithRoles = function( roles  ) {
  let url = this._baseUrl + "/_rolegroups";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = roles;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getLight = function( uid  ) {
  let url = this._baseUrl + "/{uid}/light";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getMembers = function( uid  ) {
  let url = this._baseUrl + "/{uid}/members";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getParents = function( uid  ) {
  let url = this._baseUrl + "/{uid}/parents";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.getRoles = function( uid  ) {
  let url = this._baseUrl + "/{uid}/roles";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.memberOf = function( uid  ) {
  let url = this._baseUrl + "/{uid}/groups";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.memberOfGroups = function( uid  ) {
  let url = this._baseUrl + "/{uid}/groupUids";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.remove = function( uid ,  members  ) {
  let url = this._baseUrl + "/{uid}/members";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  body = members;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.search = function( query  ) {
  let url = this._baseUrl + "/_search";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = query;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.setExtId = function( uid ,  arg1  ) {
  let url = this._baseUrl + "/{uid}/_extId";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = arg1;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.setRoles = function( uid ,  roles  ) {
  let url = this._baseUrl + "/{uid}/roles";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = roles;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.touch = function( uid ,  update_vcards  ) {
  let url = this._baseUrl + "/{uid}/_touch";

  url = url.replace("{uid}", uid);

  url += "?update_vcards=" + encodeURIComponent(update_vcards);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
GroupClient.prototype.update = function( uid ,  group  ) {
  let url = this._baseUrl + "/{uid}";

  url = url.replace("{uid}", uid);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = group;
  return this._execute(cmd, body);
};

GroupClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
