/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
FileHostingClient._rpcClient;

/**
 * URL
 */
FileHostingClient._baseUrl;

/**
 * @type {string} domainUid
 * @private
 */
FileHostingClient.prototype._domainUid;

/**
 * @constructor
 */ 
function FileHostingClient(base, sid , domainUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/filehosting/{domainUid}';
  
  this._domainUid = domainUid;
  this._baseUrl = this._baseUrl.replace('{domainUid}',domainUid);
};

FileHostingClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
FileHostingClient.prototype.delete_ = function( path  ) {
  let url = this._baseUrl + "/{path}";

  url = url.replace("{path}", path);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.exists = function( path  ) {
  let url = this._baseUrl + "/{path}/_exists";

  url = url.replace("{path}", path);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.find = function( query  ) {
  let url = this._baseUrl + "/_find";


  url += "?query=" + encodeURIComponent(query);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.get = function( path  ) {
  let url = this._baseUrl + "/{path}/_content";

  url = url.replace("{path}", path);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.getConfiguration = function() {
  let url = this._baseUrl + "/_config";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.info = function() {
  let url = this._baseUrl + "/_info";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.list = function( path  ) {
  let url = this._baseUrl + "/_list";


  url += "?path=" + encodeURIComponent(path);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.share = function( path ,  downloadLimit ,  expirationDate  ) {
  let url = this._baseUrl + "/_share";


  url += "?path=" + encodeURIComponent(path);
  url += "&downloadLimit=" + encodeURIComponent(downloadLimit);
  url += "&expirationDate=" + encodeURIComponent(expirationDate);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.store = function( path ,  document  ) {
  let url = this._baseUrl + "/{path}";

  url = url.replace("{path}", path);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = document;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.storeAndShare = function( path ,  downloadLimit ,  expirationDate ,  document  ) {
  let url = this._baseUrl + "/_store_share";


  url += "?path=" + encodeURIComponent(path);
  url += "&downloadLimit=" + encodeURIComponent(downloadLimit);
  url += "&expirationDate=" + encodeURIComponent(expirationDate);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = document;
  return this._execute(cmd, body);
};

/*
 *
 */
FileHostingClient.prototype.unShare = function( url  ) {
  let url = this._baseUrl + "/{url}/unshare";

  url = url.replace("{url}", url);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

FileHostingClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
