/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
ContainerManagementClient._rpcClient;

/**
 * URL
 */
ContainerManagementClient._baseUrl;

/**
 * @type {string} containerUid
 * @private
 */
ContainerManagementClient.prototype._containerUid;

/**
 * @constructor
 */ 
function ContainerManagementClient(base, sid , containerUid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/containers/_manage/{containerUid}';
  
  this._containerUid = containerUid;
  this._baseUrl = this._baseUrl.replace('{containerUid}',containerUid);
};

ContainerManagementClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
ContainerManagementClient.prototype.allowOfflineSync = function( subject  ) {
  let url = this._baseUrl + "/{subject}/offlineSync";

  url = url.replace("{subject}", subject);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.canAccess = function( verbsOrRoles  ) {
  let url = this._baseUrl + "/_canAccess";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = verbsOrRoles;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.canAccessVerbs = function( verbsOrRoles  ) {
  let url = this._baseUrl + "/_canAccessVerbs";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = verbsOrRoles;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.disallowOfflineSync = function( subject  ) {
  let url = this._baseUrl + "/{subject}/offlineSync";

  url = url.replace("{subject}", subject);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "DELETE", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.getAccessControlList = function() {
  let url = this._baseUrl + "/_acl";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.getAllItems = function() {
  let url = this._baseUrl + "/_list";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.getDescriptor = function() {
  let url = this._baseUrl + "/_descriptor";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.getItemCount = function() {
  let url = this._baseUrl + "/_itemCount";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.getItems = function( uids  ) {
  let url = this._baseUrl + "/_mget";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = uids;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.getSettings = function() {
  let url = this._baseUrl + "/_settings";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.setAccessControlList = function( entries  ) {
  let url = this._baseUrl + "/_acl";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = entries;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.setPersonalSettings = function( settings  ) {
  let url = this._baseUrl + "/_personalSettings";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = settings;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.setSetting = function( key ,  value  ) {
  let url = this._baseUrl + "/_settings/{key}";

  url = url.replace("{key}", key);

  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = value;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.setSettings = function( settings  ) {
  let url = this._baseUrl + "/_settings";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "PUT", responseType);
  let body = null;
  body = settings;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.subscribers = function() {
  let url = this._baseUrl + "/_subscription";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
ContainerManagementClient.prototype.update = function( descriptor  ) {
  let url = this._baseUrl + "/_descriptor";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = descriptor;
  return this._execute(cmd, body);
};

ContainerManagementClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
