/**
 * BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

/**
 * RPC Client
 */
AuthenticationClient._rpcClient;

/**
 * URL
 */
AuthenticationClient._baseUrl;

/**
 * @constructor
 */ 
function AuthenticationClient(base, sid ) {
  this._rpcClient = Components.classes["@blue-mind.net/rpcclient;1"].getService().wrappedJSObject;
  this._rpcClient.setAuthKey(sid ? sid : null);
  this._baseUrl = base + '/api/auth';
  
};

AuthenticationClient.prototype.setAuthKey = function(sid) {
    this._rpcClient.setAuthKey(sid);
};

/*
 *
 */
AuthenticationClient.prototype.getCurrentUser = function() {
  let url = this._baseUrl;


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.login = function( login ,  password ,  origin  ) {
  let url = this._baseUrl + "/login";


  url += "?login=" + encodeURIComponent(login);
  url += "&origin=" + encodeURIComponent(origin);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = password;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.loginWithParams = function( login ,  password ,  origin ,  interactive  ) {
  let url = this._baseUrl + "/loginWithParams";


  url += "?login=" + encodeURIComponent(login);
  url += "&origin=" + encodeURIComponent(origin);
  url += "&interactive=" + encodeURIComponent(interactive);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = password;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.logout = function() {
  let url = this._baseUrl + "/logout";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.ping = function() {
  let url = this._baseUrl + "/ping";


  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "GET", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.su = function( login  ) {
  let url = this._baseUrl + "/_su";


  url += "?login=" + encodeURIComponent(login);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.suWithParams = function( login ,  interactive  ) {
  let url = this._baseUrl + "/_suWithParams";


  url += "?login=" + encodeURIComponent(login);
  url += "&interactive=" + encodeURIComponent(interactive);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  return this._execute(cmd, body);
};

/*
 *
 */
AuthenticationClient.prototype.validate = function( login ,  password ,  origin  ) {
  let url = this._baseUrl + "/validate";


  url += "?login=" + encodeURIComponent(login);
  url += "&origin=" + encodeURIComponent(origin);
  let responseType = "";
  let cmd = this._rpcClient.newCommand(url, "POST", responseType);
  let body = null;
  body = password;
  return this._execute(cmd, body);
};

AuthenticationClient.prototype._execute = function(cmd, data) {
  cmd.getData = function() {
    if (data != null){
      return JSON.stringify(data);
    } 
    return null;
  };

  cmd.onSuccess = function(xhr) {
    let contentType = xhr.getResponseHeader("content-type");
    if (contentType == "application/json" && xhr.responseText) {
      cmd.resolve(JSON.parse(xhr.responseText));
    } else {
      cmd.resolve(xhr.response);
    }
  };

  cmd.onFailure = function(xhr) {
    let resp = xhr.response;
    if (resp != null) {
        cmd.reject(resp);
    } else {
        cmd.reject(xhr.status);
    }
  };

  let self = this;
  let result = new Promise(function(resolve, reject) {
    try {
      cmd.resolve = resolve;
      cmd.reject = reject;
      self._rpcClient.execute(cmd);
    } catch(e) {
      reject(e);
    }
  });
  return result;
}
