/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store.factories;

import java.util.concurrent.TimeUnit;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.cql.store.CqlChangelogStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.repository.IChangelogStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;

public class ChangelogStoreFactory extends CqlRepositoryFactory<IChangelogStore>
		implements IContainerBoundFactory<IChangelogStore> {

	@Override
	public Class<IChangelogStore> factoryClass() {
		return IChangelogStore.class;
	}

	@Override
	public IChangelogStore instance(BmContext context, Container container) throws ServerFault {
		return new CqlChangelogStore(container, CqlSessions.forKeyspace("core"), SequenceStores.getDefault(), 60,
				TimeUnit.DAYS, context.getSecurityContext());
	}

}
