/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.container.cql.store.factories;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.cql.store.CqlContainerStore;
import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.core.container.repository.IContainerStore;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerUidBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;

public class ByUidContainerStoreFactory extends CqlRepositoryFactory<IContainerStore>
		implements IContainerUidBoundFactory<IContainerStore> {

	@Override
	public Class<IContainerStore> factoryClass() {
		return IContainerStore.class;
	}

	@Override
	public IContainerStore instance(BmContext context, ContainerUid cUid) throws ServerFault {
		return new CqlContainerStore(CqlSessions.forKeyspace("core"), SequenceStores.getDefault(),
				context.getSecurityContext());
	}

}
