/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class AuthenticationGwtEndpoint implements net.bluemind.authentication.api.IAuthenticationAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public AuthenticationGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/auth";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public AuthenticationGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getCurrentUser(final AsyncHandler<net.bluemind.authentication.api.AuthUser> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.AuthUser>(handler) {
			@Override
			protected net.bluemind.authentication.api.AuthUser handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.AuthUserGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void login(String login, String password, String origin, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/login";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&login=" + URL.encodeQueryString(""+login);
		queryParams += "&origin=" + URL.encodeQueryString(""+origin);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.LoginResponse>(handler) {
			@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void loginWithParams(String login, String password, String origin, Boolean interactive, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/loginWithParams";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&login=" + URL.encodeQueryString(""+login);
		queryParams += "&origin=" + URL.encodeQueryString(""+origin);
		queryParams += "&interactive=" + URL.encodeQueryString(""+interactive);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.LoginResponse>(handler) {
			@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void logout(final AsyncHandler<Void> handler) {
		String postUri = "/logout";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void ping(final AsyncHandler<Void> handler) {
		String postUri = "/ping";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void su(String login, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/_su";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&login=" + URL.encodeQueryString(""+login);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.LoginResponse>(handler) {
			@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void suWithParams(String login, Boolean interactive, final AsyncHandler<net.bluemind.authentication.api.LoginResponse> handler) {
		String postUri = "/_suWithParams";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&login=" + URL.encodeQueryString(""+login);
		queryParams += "&interactive=" + URL.encodeQueryString(""+interactive);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.LoginResponse>(handler) {
			@Override
			protected net.bluemind.authentication.api.LoginResponse handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.LoginResponseGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void validate(String login, String password, String origin, final AsyncHandler<net.bluemind.authentication.api.ValidationKind> handler) {
		String postUri = "/validate";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&login=" + URL.encodeQueryString(""+login);
		queryParams += "&origin=" + URL.encodeQueryString(""+origin);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.authentication.api.ValidationKind>(handler) {
			@Override
			protected net.bluemind.authentication.api.ValidationKind handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.ValidationKindGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.authentication.api.IAuthenticationPromise promiseApi() {
		return new AuthenticationEndpointPromise(this);
	}
}
