/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */

package net.bluemind.cli.auditlog;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.cli.cmd.api.CliContext;
import net.bluemind.cli.cmd.api.ICmdLet;
import net.bluemind.cli.cmd.api.ICmdLetRegistration;
import net.bluemind.core.auditlogs.IAuditLogMgmt;
import net.bluemind.core.auditlogs.exception.AuditLogILMPolicyException;
import picocli.CommandLine.Command;

@Command(name = "get-retention", description = "Get retention duration (days) for datastream")
public class GetRetentionDurationAuditLogCommand implements Runnable, ICmdLet {
	private static final int MAX_VAL = 30;

	private static final Logger logger = LoggerFactory.getLogger(GetRetentionDurationAuditLogCommand.class);

	public static class Reg implements ICmdLetRegistration {

		@Override
		public Optional<String> group() {
			return Optional.of("auditlog");
		}

		@Override
		public Class<? extends ICmdLet> commandClass() {
			return GetRetentionDurationAuditLogCommand.class;
		}

	}

	private CliContext ctx;

	@Override
	public Runnable forContext(CliContext ctx) {
		this.ctx = ctx;
		return this;
	}

	@Override
	public void run() {
		IAuditLogMgmt service = ctx.adminApi().instance(IAuditLogMgmt.class);
		try {
			String duration = service.getRetentionDuration();
			logger.info("Retention policy is set to {}", duration);
			ctx.info("Retention policy is set to " + duration);
		} catch (AuditLogILMPolicyException e) {
			logger.info("Cannot get retention policy: {}", e.getMessage());
			ctx.info("Cannot get retention policy: " + e.getMessage());
		}

	}

}
