/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2017
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.api;

import net.bluemind.core.api.BMApi;

@BMApi(version = "3")
public class MailboxFolder {

	public String name;
	public String fullName;
	public String parentUid;
	public boolean deleted;
	public boolean virtualFolder;

	public String toString() {
		return "MailboxFolder{n: " + name + ", fn: " + fullName + ", pUid: " + parentUid + "}";
	}

	public static MailboxFolder of(String fullName) {
		MailboxFolder f = new MailboxFolder();
		f.fullName = fullName;
		if (fullName.contains("/")) {
			f.name = fullName.substring(fullName.lastIndexOf('/') + 1);
		} else {
			f.name = fullName;
		}
		return f;
	}

}
