<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * FolderCounters.
 */
class FolderCounters  {

  /*
   * @type long
   */
  public $itemId;

  /*
   * @type long
   */
  public $recordsVersion;

  /*
   * @type int
   */
  public $unseenVisible;

  /*
   * @type int
   */
  public $totalVisible;

  /*
   * @type int
   */
  public $total;

  /*
   * Constructor
   */
  public function __construct() {
    $this->itemId = 0;
    $this->recordsVersion = 0;
    $this->unseenVisible = 0;
    $this->totalVisible = 0;
    $this->total = 0;
  }

  public function toMap() {
    $data = array(    
        "itemId" => empty($this->itemId) ? null : $this->itemId,    
        "recordsVersion" => empty($this->recordsVersion) ? null : $this->recordsVersion,    
        "unseenVisible" => empty($this->unseenVisible) ? null : $this->unseenVisible,    
        "totalVisible" => empty($this->totalVisible) ? null : $this->totalVisible,    
        "total" => empty($this->total) ? null : $this->total);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
