package net.bluemind.webmodule.project.vite.internal;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.osgi.framework.Bundle;

import net.bluemind.webmodule.server.js.JsEntry;
import net.bluemind.webmodule.server.js.JsEntry.Type;

public class ViteProductionResource extends AbstractViteResource {

	public ViteProductionResource(Bundle bundle) {
		super(bundle);
	}

	public List<JsEntry> getJsEntries() {
		return chunks.stream().filter(chunk -> chunk.isEntry)
				.map(chunk -> new JsEntry(chunk.file, Type.MODULE, dependencies, getBundleName()))
				.collect(Collectors.toList());
	}

	public List<String> getCss() {
		return chunks.stream().filter(chunk -> chunk.isEntry).flatMap(chunk -> chunk.css.stream())
				.collect(Collectors.toList());
	}

	protected void loadResources() {
		chunks.stream().flatMap(chunck -> loadResources(chunck)).forEach(this::load);
	}

	private Stream<Path> loadResources(ManifestChunk chunck) {
		// Not sure if all assets, imports and dynamicImports are also listed as
		// manifest chunk
		Set<String> files = new HashSet<String>();
		files.add(chunck.file);
		if (chunck.isEntry || chunck.isDynamicEntry) {
			files.add(chunck.file + ".map");
		}
		files.addAll(chunck.css);
		files.addAll(chunck.assets);
		files.addAll(chunck.imports);
		files.addAll(chunck.dynamicImports);
		return files.stream().map(this::resolve);
	}

}
