/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.restore.directory;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.core.task.api.TaskRef;
import net.bluemind.core.task.api.TaskStatus;
import net.bluemind.core.task.service.TaskUtils;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.api.IDataProtect;
import net.bluemind.dataprotect.api.RestoreDefinition;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;

public abstract class RestoreDirWorker<T> implements IRestoreDirWorker<T> {

	protected IMonitoredRestoreRestorableItem restorableItem;
	protected DataProtectGeneration backup;
	protected IServiceProvider live;

	protected RestoreDirWorker(DataProtectGeneration backup, IMonitoredRestoreRestorableItem restorableItem) {
		this.restorableItem = restorableItem;
		this.backup = backup;
		this.live = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM);
	}

	protected void executeTask(RestoreDefinition definition) {
		TaskRef run = live.instance(IDataProtect.class).run(definition);
		TaskStatus taskResult = TaskUtils.wait(ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM), run);
		if (taskResult.state == TaskStatus.State.InError) {
			throw new ServerFault("Error while restoring " + definition + ": " + taskResult.lastLogEntry);
		}
	}

}
