/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.common.backup;

import net.bluemind.core.container.model.ContainerDescriptor;
import net.bluemind.core.container.model.ItemValue;

public class BackupContainerItemDescriptor<T> {

	private ContainerDescriptor container;
	private ItemValue<T> item;

	public BackupContainerItemDescriptor() {
	}

	public BackupContainerItemDescriptor(ContainerDescriptor container, ItemValue<T> item) {
		this.container = container;
		this.item = item;
	}

	public ContainerDescriptor getContainer() {
		return container;
	}

	public ItemValue<T> getItem() {
		return item;
	}

	public void setContainer(ContainerDescriptor container) {
		this.container = container;
	}

	public void setItem(ItemValue<T> item) {
		this.item = item;
	}

}
