/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.metrics.alerts.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AlertInfoGwtSerDer implements GwtSerDer<net.bluemind.metrics.alerts.api.AlertInfo> {

	public AlertInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.metrics.alerts.api.AlertInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.metrics.alerts.api.AlertInfo ret = new net.bluemind.metrics.alerts.api.AlertInfo();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.metrics.alerts.api.AlertInfo ret, JSONObject json) {
		JSONValue timeJSON = json.get("time");
		ret.time =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(timeJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue datalocationJSON = json.get("datalocation");
		ret.datalocation =  GwtSerDerUtils.STRING.deserialize(datalocationJSON);
		JSONValue hostJSON = json.get("host");
		ret.host =  GwtSerDerUtils.STRING.deserialize(hostJSON);
		JSONValue levelJSON = json.get("level");
		ret.level =  new net.bluemind.metrics.alerts.api.gwt.serder.AlertLevelGwtSerDer().deserialize(levelJSON);
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue productJSON = json.get("product");
		ret.product =  GwtSerDerUtils.STRING.deserialize(productJSON);
	}

	public void deserializeTo(net.bluemind.metrics.alerts.api.AlertInfo ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("time")) {
			JSONValue timeJSON = json.get("time");
			ret.time =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(timeJSON);
		}
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("datalocation")) {
			JSONValue datalocationJSON = json.get("datalocation");
			ret.datalocation =  GwtSerDerUtils.STRING.deserialize(datalocationJSON);
		}
		if (!childPropertiesToIgnore.contains("host")) {
			JSONValue hostJSON = json.get("host");
			ret.host =  GwtSerDerUtils.STRING.deserialize(hostJSON);
		}
		if (!childPropertiesToIgnore.contains("level")) {
			JSONValue levelJSON = json.get("level");
			ret.level =  new net.bluemind.metrics.alerts.api.gwt.serder.AlertLevelGwtSerDer().deserialize(levelJSON);
		}
		if (!childPropertiesToIgnore.contains("message")) {
			JSONValue messageJSON = json.get("message");
			ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		}
		if (!childPropertiesToIgnore.contains("product")) {
			JSONValue productJSON = json.get("product");
			ret.product =  GwtSerDerUtils.STRING.deserialize(productJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.metrics.alerts.api.AlertInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.metrics.alerts.api.AlertInfo o, JSONObject ret) {

		ret.put("time",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.time ));
		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("datalocation",  GwtSerDerUtils.STRING.serialize( o.datalocation ));
		ret.put("host",  GwtSerDerUtils.STRING.serialize( o.host ));
		ret.put("level",  new net.bluemind.metrics.alerts.api.gwt.serder.AlertLevelGwtSerDer().serialize( o.level ));
		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("product",  GwtSerDerUtils.STRING.serialize( o.product ));
	}

	public void serializeTo(net.bluemind.metrics.alerts.api.AlertInfo o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("time")) {
			ret.put("time",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.time ));
		}
		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("datalocation")) {
			ret.put("datalocation",  GwtSerDerUtils.STRING.serialize( o.datalocation ));
		}
		if (!childPropertiesToIgnore.contains("host")) {
			ret.put("host",  GwtSerDerUtils.STRING.serialize( o.host ));
		}
		if (!childPropertiesToIgnore.contains("level")) {
			ret.put("level",  new net.bluemind.metrics.alerts.api.gwt.serder.AlertLevelGwtSerDer().serialize( o.level ));
		}
		if (!childPropertiesToIgnore.contains("message")) {
			ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		}
		if (!childPropertiesToIgnore.contains("product")) {
			ret.put("product",  GwtSerDerUtils.STRING.serialize( o.product ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}