/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.metrics.alerts.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ProductChecksGwtEndpoint implements net.bluemind.metrics.alerts.api.IProductChecksAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ProductChecksGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/check";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public ProductChecksGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void availableChecks(final AsyncHandler<Set<String>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<String>>(handler) {
			@Override
			protected Set<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void check(String checkName, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{checkName}";

		postUri = postUri.replace("{checkName}", URL.encodePathSegment(""+checkName));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void lastResult(String checkName, final AsyncHandler<net.bluemind.metrics.alerts.api.CheckResult> handler) {
		String postUri = "/{checkName}";

		postUri = postUri.replace("{checkName}", URL.encodePathSegment(""+checkName));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.metrics.alerts.api.CheckResult>(handler) {
			@Override
			protected net.bluemind.metrics.alerts.api.CheckResult handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.metrics.alerts.api.gwt.serder.CheckResultGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.metrics.alerts.api.IProductChecksPromise promiseApi() {
		return new ProductChecksEndpointPromise(this);
	}
}
