/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.metrics.alerts.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MonitoringSockJsEndpoint implements net.bluemind.metrics.alerts.api.IMonitoringAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MonitoringSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/monitoring";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public MonitoringSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getAlerts(int limit, boolean filterResolved, List<net.bluemind.metrics.alerts.api.AlertLevel> levels, final AsyncHandler<List<net.bluemind.metrics.alerts.api.AlertInfo>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("limit", URL.encodeQueryString(""+limit));
		params.put("filterResolved", URL.encodeQueryString(""+filterResolved));
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(new net.bluemind.metrics.alerts.api.gwt.serder.AlertLevelGwtSerDer()).serialize( levels);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.metrics.alerts.api.AlertInfo>>(handler) {
					@Override
			protected List<net.bluemind.metrics.alerts.api.AlertInfo> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.metrics.alerts.api.gwt.serder.AlertInfoGwtSerDer()).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.metrics.alerts.api.IMonitoringPromise promiseApi() {
		return new MonitoringEndpointPromise(this);
	}

}
