/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.role.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class RolesEndpointPromise implements net.bluemind.role.api.IRolesPromise {

	private net.bluemind.role.api.IRolesAsync impl;

	public RolesEndpointPromise(net.bluemind.role.api.IRolesAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Set<net.bluemind.role.api.RoleDescriptor>> getRoles() {
		
		CompletableFuture<Set<net.bluemind.role.api.RoleDescriptor>> ret = new CompletableFuture<Set<net.bluemind.role.api.RoleDescriptor>>();
		AsyncHandler<Set<net.bluemind.role.api.RoleDescriptor>> handler = new AsyncHandler<Set<net.bluemind.role.api.RoleDescriptor>>() {
			public void success(Set<net.bluemind.role.api.RoleDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRoles( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<net.bluemind.role.api.RolesCategory>> getRolesCategories() {
		
		CompletableFuture<Set<net.bluemind.role.api.RolesCategory>> ret = new CompletableFuture<Set<net.bluemind.role.api.RolesCategory>>();
		AsyncHandler<Set<net.bluemind.role.api.RolesCategory>> handler = new AsyncHandler<Set<net.bluemind.role.api.RolesCategory>>() {
			public void success(Set<net.bluemind.role.api.RolesCategory> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRolesCategories( handler);
		return ret;
	}

}
