/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.smime.cacerts.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SmimeCacertInfosGwtSerDer implements GwtSerDer<net.bluemind.smime.cacerts.api.SmimeCacertInfos> {

	public SmimeCacertInfosGwtSerDer( ) {
	}

	@Override
	public net.bluemind.smime.cacerts.api.SmimeCacertInfos deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.smime.cacerts.api.SmimeCacertInfos ret = new net.bluemind.smime.cacerts.api.SmimeCacertInfos();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.SmimeCacertInfos ret, JSONObject json) {
		JSONValue cacertUidJSON = json.get("cacertUid");
		ret.cacertUid =  GwtSerDerUtils.STRING.deserialize(cacertUidJSON);
		JSONValue cacertIssuerJSON = json.get("cacertIssuer");
		ret.cacertIssuer =  GwtSerDerUtils.STRING.deserialize(cacertIssuerJSON);
		JSONValue cacertSubjectJSON = json.get("cacertSubject");
		ret.cacertSubject =  GwtSerDerUtils.STRING.deserialize(cacertSubjectJSON);
		JSONValue revocationsJSON = json.get("revocations");
		ret.revocations =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer()).deserialize(revocationsJSON);
	}

	public void deserializeTo(net.bluemind.smime.cacerts.api.SmimeCacertInfos ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("cacertUid")) {
			JSONValue cacertUidJSON = json.get("cacertUid");
			ret.cacertUid =  GwtSerDerUtils.STRING.deserialize(cacertUidJSON);
		}
		if (!childPropertiesToIgnore.contains("cacertIssuer")) {
			JSONValue cacertIssuerJSON = json.get("cacertIssuer");
			ret.cacertIssuer =  GwtSerDerUtils.STRING.deserialize(cacertIssuerJSON);
		}
		if (!childPropertiesToIgnore.contains("cacertSubject")) {
			JSONValue cacertSubjectJSON = json.get("cacertSubject");
			ret.cacertSubject =  GwtSerDerUtils.STRING.deserialize(cacertSubjectJSON);
		}
		if (!childPropertiesToIgnore.contains("revocations")) {
			JSONValue revocationsJSON = json.get("revocations");
			ret.revocations =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer()).deserialize(revocationsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.smime.cacerts.api.SmimeCacertInfos o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.SmimeCacertInfos o, JSONObject ret) {

		ret.put("cacertUid",  GwtSerDerUtils.STRING.serialize( o.cacertUid ));
		ret.put("cacertIssuer",  GwtSerDerUtils.STRING.serialize( o.cacertIssuer ));
		ret.put("cacertSubject",  GwtSerDerUtils.STRING.serialize( o.cacertSubject ));
		ret.put("revocations",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer()).serialize( o.revocations ));
	}

	public void serializeTo(net.bluemind.smime.cacerts.api.SmimeCacertInfos o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("cacertUid")) {
			ret.put("cacertUid",  GwtSerDerUtils.STRING.serialize( o.cacertUid ));
		}
		if (!childPropertiesToIgnore.contains("cacertIssuer")) {
			ret.put("cacertIssuer",  GwtSerDerUtils.STRING.serialize( o.cacertIssuer ));
		}
		if (!childPropertiesToIgnore.contains("cacertSubject")) {
			ret.put("cacertSubject",  GwtSerDerUtils.STRING.serialize( o.cacertSubject ));
		}
		if (!childPropertiesToIgnore.contains("revocations")) {
			ret.put("revocations",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.smime.cacerts.api.gwt.serder.SmimeRevocationGwtSerDer()).serialize( o.revocations ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}