/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2021
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.backup.continuous.events;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.dataprotect.api.IDataProtect;
import net.bluemind.dataprotect.api.RetentionPolicy;
import net.bluemind.dataprotect.hook.IDpHook;
import net.bluemind.system.api.SystemState;
import net.bluemind.system.stateobserver.IStateListener;

public class RetentionContinuousHook implements IDpHook, IStateListener {

	private static final Logger logger = LoggerFactory.getLogger(RetentionContinuousHook.class);
	private SystemState cur;

	@Override
	public void stateChanged(SystemState newState) {
		if (newState == SystemState.CORE_STATE_RUNNING && newState != cur) {
			retentionChanged();
		}
		cur = newState;
	}

	@Override
	public void retentionChanged() {
		BaseContainerDescriptor instContainer = BaseContainerDescriptor.create("dp", "dp", "system", "dp", null, true);

		ServerSideServiceProvider prov = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM);

		IDataProtect dp = prov.instance(IDataProtect.class);
		RetentionPolicy rp = dp.getRetentionPolicy();

		ItemValue<RetentionPolicy> asItem = ItemValue.create("dataprotect_retention_policy", rp);

		TxOutboxLookup.forContainer(instContainer).forKafka(asItem, null, false);
		logger.info("Pushed retention policy {} to installation container", asItem);
	}

}
