/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEvent> {

	private net.bluemind.icalendar.api.gwt.serder.ICalendarElementGwtSerDer parent = new  net.bluemind.icalendar.api.gwt.serder.ICalendarElementGwtSerDer();
	public VEventGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEvent deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEvent ret = new net.bluemind.calendar.api.VEvent();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEvent ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue dtendJSON = json.get("dtend");
		ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		JSONValue transparencyJSON = json.get("transparency");
		ret.transparency =  new net.bluemind.calendar.api.gwt.serder.VEventTransparencyGwtSerDer().deserialize(transparencyJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEvent ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("dtend")) {
			JSONValue dtendJSON = json.get("dtend");
			ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		}
		if (!childPropertiesToIgnore.contains("transparency")) {
			JSONValue transparencyJSON = json.get("transparency");
			ret.transparency =  new net.bluemind.calendar.api.gwt.serder.VEventTransparencyGwtSerDer().deserialize(transparencyJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEvent o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEvent o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		ret.put("transparency",  new net.bluemind.calendar.api.gwt.serder.VEventTransparencyGwtSerDer().serialize( o.transparency ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEvent o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("dtend")) {
			ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		}
		if (!childPropertiesToIgnore.contains("transparency")) {
			ret.put("transparency",  new net.bluemind.calendar.api.gwt.serder.VEventTransparencyGwtSerDer().serialize( o.transparency ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}