/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CalendarViewChangesGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.CalendarViewChanges> {

	public CalendarViewChangesGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.CalendarViewChanges deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.CalendarViewChanges ret = new net.bluemind.calendar.api.CalendarViewChanges();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarViewChanges ret, JSONObject json) {
		JSONValue addJSON = json.get("add");
		ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemAddGwtSerDer()).deserialize(addJSON);
		JSONValue modifyJSON = json.get("modify");
		ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		JSONValue deleteJSON = json.get("delete");
		ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarViewChanges ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("add")) {
			JSONValue addJSON = json.get("add");
			ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemAddGwtSerDer()).deserialize(addJSON);
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			JSONValue modifyJSON = json.get("modify");
			ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			JSONValue deleteJSON = json.get("delete");
			ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.CalendarViewChanges o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarViewChanges o, JSONObject ret) {

		ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemAddGwtSerDer()).serialize( o.add ));
		ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemModifyGwtSerDer()).serialize( o.modify ));
		ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemDeleteGwtSerDer()).serialize( o.delete ));
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarViewChanges o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("add")) {
			ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemAddGwtSerDer()).serialize( o.add ));
		}
		if (!childPropertiesToIgnore.contains("modify")) {
			ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemModifyGwtSerDer()).serialize( o.modify ));
		}
		if (!childPropertiesToIgnore.contains("delete")) {
			ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarViewChangesItemDeleteGwtSerDer()).serialize( o.delete ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}