/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CalendarSettingsDataGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.CalendarSettingsData> {

	public CalendarSettingsDataGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.CalendarSettingsData deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.CalendarSettingsData ret = new net.bluemind.calendar.api.CalendarSettingsData();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarSettingsData ret, JSONObject json) {
		JSONValue workingDaysJSON = json.get("workingDays");
		ret.workingDays =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarSettingsDataDayGwtSerDer()).deserialize(workingDaysJSON);
		JSONValue dayStartJSON = json.get("dayStart");
		ret.dayStart =  GwtSerDerUtils.INT.deserialize(dayStartJSON);
		JSONValue dayEndJSON = json.get("dayEnd");
		ret.dayEnd =  GwtSerDerUtils.INT.deserialize(dayEndJSON);
		JSONValue minDurationJSON = json.get("minDuration");
		ret.minDuration =  GwtSerDerUtils.INT.deserialize(minDurationJSON);
		JSONValue timezoneIdJSON = json.get("timezoneId");
		ret.timezoneId =  GwtSerDerUtils.STRING.deserialize(timezoneIdJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarSettingsData ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("workingDays")) {
			JSONValue workingDaysJSON = json.get("workingDays");
			ret.workingDays =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarSettingsDataDayGwtSerDer()).deserialize(workingDaysJSON);
		}
		if (!childPropertiesToIgnore.contains("dayStart")) {
			JSONValue dayStartJSON = json.get("dayStart");
			ret.dayStart =  GwtSerDerUtils.INT.deserialize(dayStartJSON);
		}
		if (!childPropertiesToIgnore.contains("dayEnd")) {
			JSONValue dayEndJSON = json.get("dayEnd");
			ret.dayEnd =  GwtSerDerUtils.INT.deserialize(dayEndJSON);
		}
		if (!childPropertiesToIgnore.contains("minDuration")) {
			JSONValue minDurationJSON = json.get("minDuration");
			ret.minDuration =  GwtSerDerUtils.INT.deserialize(minDurationJSON);
		}
		if (!childPropertiesToIgnore.contains("timezoneId")) {
			JSONValue timezoneIdJSON = json.get("timezoneId");
			ret.timezoneId =  GwtSerDerUtils.STRING.deserialize(timezoneIdJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.CalendarSettingsData o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarSettingsData o, JSONObject ret) {

		ret.put("workingDays",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarSettingsDataDayGwtSerDer()).serialize( o.workingDays ));
		ret.put("dayStart",  GwtSerDerUtils.INT.serialize( o.dayStart ));
		ret.put("dayEnd",  GwtSerDerUtils.INT.serialize( o.dayEnd ));
		ret.put("minDuration",  GwtSerDerUtils.INT.serialize( o.minDuration ));
		ret.put("timezoneId",  GwtSerDerUtils.STRING.serialize( o.timezoneId ));
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarSettingsData o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("workingDays")) {
			ret.put("workingDays",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.CalendarSettingsDataDayGwtSerDer()).serialize( o.workingDays ));
		}
		if (!childPropertiesToIgnore.contains("dayStart")) {
			ret.put("dayStart",  GwtSerDerUtils.INT.serialize( o.dayStart ));
		}
		if (!childPropertiesToIgnore.contains("dayEnd")) {
			ret.put("dayEnd",  GwtSerDerUtils.INT.serialize( o.dayEnd ));
		}
		if (!childPropertiesToIgnore.contains("minDuration")) {
			ret.put("minDuration",  GwtSerDerUtils.INT.serialize( o.minDuration ));
		}
		if (!childPropertiesToIgnore.contains("timezoneId")) {
			ret.put("timezoneId",  GwtSerDerUtils.STRING.serialize( o.timezoneId ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}