/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ItemVersionGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ItemVersion> {

	public ItemVersionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ItemVersion deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ItemVersion ret = new net.bluemind.core.container.model.ItemVersion();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemVersion ret, JSONObject json) {
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.LONG.deserialize(idJSON);
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		JSONValue timestampJSON = json.get("timestamp");
		ret.timestamp =  GwtSerDerUtils.DATE.deserialize(timestampJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemVersion ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.LONG.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("version")) {
			JSONValue versionJSON = json.get("version");
			ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		}
		if (!childPropertiesToIgnore.contains("timestamp")) {
			JSONValue timestampJSON = json.get("timestamp");
			ret.timestamp =  GwtSerDerUtils.DATE.deserialize(timestampJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ItemVersion o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ItemVersion o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.LONG.serialize( o.id ));
		ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		ret.put("timestamp",  GwtSerDerUtils.DATE.serialize( o.timestamp ));
	}

	public void serializeTo(net.bluemind.core.container.model.ItemVersion o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.LONG.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("version")) {
			ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		}
		if (!childPropertiesToIgnore.contains("timestamp")) {
			ret.put("timestamp",  GwtSerDerUtils.DATE.serialize( o.timestamp ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}