/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ItemValueExistsGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ItemValueExists> {

	public ItemValueExistsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ItemValueExists deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ItemValueExists ret = new net.bluemind.core.container.api.ItemValueExists();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ItemValueExists ret, JSONObject json) {
		JSONValue itemExistsJSON = json.get("itemExists");
		ret.itemExists =  GwtSerDerUtils.BOOLEAN.deserialize(itemExistsJSON);
		JSONValue valueExistsJSON = json.get("valueExists");
		ret.valueExists =  GwtSerDerUtils.BOOLEAN.deserialize(valueExistsJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.ItemValueExists ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("itemExists")) {
			JSONValue itemExistsJSON = json.get("itemExists");
			ret.itemExists =  GwtSerDerUtils.BOOLEAN.deserialize(itemExistsJSON);
		}
		if (!childPropertiesToIgnore.contains("valueExists")) {
			JSONValue valueExistsJSON = json.get("valueExists");
			ret.valueExists =  GwtSerDerUtils.BOOLEAN.deserialize(valueExistsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ItemValueExists o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ItemValueExists o, JSONObject ret) {

		ret.put("itemExists",  GwtSerDerUtils.BOOLEAN.serialize( o.itemExists ));
		ret.put("valueExists",  GwtSerDerUtils.BOOLEAN.serialize( o.valueExists ));
	}

	public void serializeTo(net.bluemind.core.container.api.ItemValueExists o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("itemExists")) {
			ret.put("itemExists",  GwtSerDerUtils.BOOLEAN.serialize( o.itemExists ));
		}
		if (!childPropertiesToIgnore.contains("valueExists")) {
			ret.put("valueExists",  GwtSerDerUtils.BOOLEAN.serialize( o.valueExists ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}