/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerSubscriptionDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ContainerSubscriptionDescriptor> {

	private net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer parent = new  net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer();
	public ContainerSubscriptionDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ContainerSubscriptionDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ContainerSubscriptionDescriptor ret = new net.bluemind.core.container.api.ContainerSubscriptionDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscriptionDescriptor ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue ownerDisplayNameJSON = json.get("ownerDisplayName");
		ret.ownerDisplayName =  GwtSerDerUtils.STRING.deserialize(ownerDisplayNameJSON);
		JSONValue ownerDirEntryPathJSON = json.get("ownerDirEntryPath");
		ret.ownerDirEntryPath =  GwtSerDerUtils.STRING.deserialize(ownerDirEntryPathJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscriptionDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("ownerDisplayName")) {
			JSONValue ownerDisplayNameJSON = json.get("ownerDisplayName");
			ret.ownerDisplayName =  GwtSerDerUtils.STRING.deserialize(ownerDisplayNameJSON);
		}
		if (!childPropertiesToIgnore.contains("ownerDirEntryPath")) {
			JSONValue ownerDirEntryPathJSON = json.get("ownerDirEntryPath");
			ret.ownerDirEntryPath =  GwtSerDerUtils.STRING.deserialize(ownerDirEntryPathJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ContainerSubscriptionDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscriptionDescriptor o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("ownerDisplayName",  GwtSerDerUtils.STRING.serialize( o.ownerDisplayName ));
		ret.put("ownerDirEntryPath",  GwtSerDerUtils.STRING.serialize( o.ownerDirEntryPath ));
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscriptionDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("ownerDisplayName")) {
			ret.put("ownerDisplayName",  GwtSerDerUtils.STRING.serialize( o.ownerDisplayName ));
		}
		if (!childPropertiesToIgnore.contains("ownerDirEntryPath")) {
			ret.put("ownerDirEntryPath",  GwtSerDerUtils.STRING.serialize( o.ownerDirEntryPath ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}