/* BEGIN LICENSE
* Copyright © Blue Mind SAS, 2012-2016
*
* This file is part of BlueMind. BlueMind is a messaging and collaborative
* solution.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of either the GNU Affero General Public License as
* published by the Free Software Foundation (version 3 of the License).
*
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*
* See LICENSE.txt
* END LICENSE
*/
package net.bluemind.dataprotect.user.impl.pg;

import java.util.List;
import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.dataprotect.api.DPError;
import net.bluemind.dataprotect.api.DPError.DPKind;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.common.restore.IMonitoredRestoreRestorableItem;
import net.bluemind.dataprotect.service.BackupDataProvider;
import net.bluemind.dataprotect.user.impl.UserRestoreWorker;
import net.bluemind.group.api.Group;
import net.bluemind.mailbox.api.IMailboxes;
import net.bluemind.system.api.Credential;
import net.bluemind.system.api.IInternalCredentials;
import net.bluemind.tag.api.ITagUids;
import net.bluemind.tag.api.ITags;
import net.bluemind.tag.api.TagChanges;
import net.bluemind.tag.api.TagChanges.ItemAdd;
import net.bluemind.user.api.IUser;
import net.bluemind.user.api.IUserSettings;
import net.bluemind.user.api.User;

public class RestoreUserTaskPg {

	private static final Logger logger = LoggerFactory.getLogger(RestoreUserTaskPg.class);
	private final DataProtectGeneration backup;
	private IMonitoredRestoreRestorableItem restorableItem;
	private final UserRestoreWorker userWorker;

	/**
	 * @deprecated REMOVE THIS IN BlueMind 6+
	 */
	@Deprecated
	public RestoreUserTaskPg(DataProtectGeneration backup, IMonitoredRestoreRestorableItem item,
			UserRestoreWorker userWorker) {
		this.backup = backup;
		this.restorableItem = item;
		this.userWorker = userWorker;
	}

	public void run() {
		logger.info("Restoring user {}:{}", restorableItem.entryUid(), restorableItem.displayName());

		try (BackupDataProvider bdp = new BackupDataProvider(null, SecurityContext.SYSTEM,
				restorableItem.getMonitor())) {
			BmContext backupContext = bdp.createContextWithData(backup, restorableItem.item());
			IServiceProvider back = backupContext.provider();

			IUser userService = back.instance(IUser.class, restorableItem.domain());
			ItemValue<User> backupUser = userService.getComplete(restorableItem.entryUid());
			List<ItemValue<Group>> memberOf = userService.memberOf(restorableItem.entryUid());
			backupUser.value.password = UUID.randomUUID().toString();

			ItemValue<User> liveUser = userWorker.createOrUpdateLiveEntry(backupUser);
			restorableItem.setLiveEntryUid(liveUser.uid);

			userWorker.restoreUserPassword(backupContext, backupUser.internalId, liveUser.internalId);

			IUserSettings settings = back.instance(IUserSettings.class, restorableItem.domain());
			userWorker.restoreUserSettings(settings.get(restorableItem.entryUid()));

			ITags tagsBackup = back.instance(ITags.class, ITagUids.TYPE + "_" + restorableItem.entryUid());
			List<TagChanges.ItemAdd> userTags = tagsBackup.all().stream().map(tag -> ItemAdd.create(tag.uid, tag.value))
					.toList();
			userWorker.restoreUserTags(userTags);

			IMailboxes mboxesBackup = back.instance(IMailboxes.class, restorableItem.domain());
			userWorker.restoreUserFilters(mboxesBackup.getMailboxFilter(restorableItem.entryUid()));

			IInternalCredentials credentialService = back.instance(IInternalCredentials.class, restorableItem.domain());
			List<Credential> credentials = credentialService.getUserCredentials(restorableItem.entryUid());
			userWorker.restoreUserCredentials(credentials);

			userWorker.restoreGroupMembership(memberOf);
			userWorker.restoreEntryDependantContainers();

			restorableItem.monitorLog(
					"user " + restorableItem.entryUid() + ":" + restorableItem.displayName() + " restored", "");
		} catch (Exception e) {
			logger.error("Error while restoring user", e);
			restorableItem.errors().add(DPError.restore(e.getMessage(), restorableItem.entryUid(), DPKind.USER));
		} finally {
			restorableItem.endTask();
		}

	}

}
