/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.user.impl;

import java.util.List;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.dataprotect.api.GenerationIndex;
import net.bluemind.dataprotect.common.backup.RestorableDirEntry;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.group.api.Group;
import net.bluemind.group.api.Member;

public class RestorableGroup extends RestorableDirEntry<Group> {

	public List<Member> members;

	public RestorableGroup() {
		super();
	}

	public RestorableGroup(ItemValue<DirEntry> dirEntry, ItemValue<Group> item, List<Member> members) {
		super(dirEntry, item);
		this.members = members;
	}

	@Override
	public GenerationIndex fromRestorable() {
		return new GenerationIndex(dirEntry.value.entryUid, dirEntry.displayName, dirEntry.value.email,
				dirEntry.value.path, dirEntry.value.kind, dirEntry.value.dataLocation);
	}

}
