<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterVacation.
 */
class MailFilterVacation  {

  /*
   * @type boolean
   */
  public $enabled;

  /*
   * @type javautilDate
   */
  public $start;

  /*
   * @type javautilDate
   */
  public $end;

  /*
   * @type String
   */
  public $text;

  /*
   * @type String
   */
  public $textHtml;

  /*
   * @type String
   */
  public $subject;

  /*
   * Constructor
   */
  public function __construct() {
    $this->enabled = false;
    $this->start = null;
    $this->end = null;
    $this->text = "";
    $this->textHtml = "";
    $this->subject = "";
  }

  public function toMap() {
    $data = array(    
        "enabled" => empty($this->enabled) ? null : $this->enabled,    
        "start" => empty($this->start) ? null : $this->start,    
        "end" => empty($this->end) ? null : $this->end,    
        "text" => empty($this->text) ? null : $this->text,    
        "textHtml" => empty($this->textHtml) ? null : $this->textHtml,    
        "subject" => empty($this->subject) ? null : $this->subject);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
