<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterForwarding.
 */
class MailFilterForwarding  {

  /*
   * @type boolean
   */
  public $enabled;

  /*
   * @type boolean
   */
  public $localCopy;

  /*
   * @type Set
   */
  public $emails;

  /*
   * Constructor
   */
  public function __construct() {
    $this->enabled = false;
    $this->localCopy = false;
    $this->emails = array();
  }

  public function toMap() {
    $data = array(    
        "enabled" => empty($this->enabled) ? null : $this->enabled,    
        "localCopy" => empty($this->localCopy) ? null : $this->localCopy,    
        "emails" => empty($this->emails) ? null : $this->emails);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
