/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.delivery.rules.auditlog;

import java.util.ArrayList;
import java.util.List;

import net.bluemind.core.auditlogs.AuditLogUpdateStatus;
import net.bluemind.core.auditlogs.ContentElement;
import net.bluemind.core.auditlogs.ContentElement.ContentElementBuilder;
import net.bluemind.core.auditlogs.ILogMapperProvider;
import net.bluemind.core.container.model.ChangeLogEntry.Type;
import net.bluemind.delivery.rules.RuleEngine.RuleActionAndContent;

public class RuleAuditLogMapper implements ILogMapperProvider<RuleActionAndContent> {

	@Override
	public ContentElement createContentElement(RuleActionAndContent ruleAction, Type type) {
		return buildContent(ruleAction);
	}

	@Override
	public AuditLogUpdateStatus createUpdateMessage(RuleActionAndContent oldValue, RuleActionAndContent newValue) {
		return new AuditLogUpdateStatus();
	}

	private ContentElement buildContent(RuleActionAndContent ruleAction) {
		ContentElementBuilder builder = new ContentElement.ContentElementBuilder();
		builder.key(ruleAction.nextContent().message().getMessageId()).author(List.of(ruleAction.nextContent().from()));
		List<String> with = new ArrayList<>();
		with.add(ruleAction.nextContent().from());
		if (ruleAction.nextContent().message().getTo() != null) {
			with.addAll(
					ruleAction.nextContent().message().getTo().flatten().stream().map(m -> m.getAddress()).toList());
		}
		if (ruleAction.nextContent().message().getCc() != null) {
			with.addAll(
					ruleAction.nextContent().message().getCc().flatten().stream().map(m -> m.getAddress()).toList());
		}
		builder.with(with);
		builder.description(ruleAction.nextContent().message().getSubject());
		return builder.build();
	}
}
