/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2021
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.mailbox.deserializer;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.dataprotect.service.internal.MailboxIndexJson;

public class RestoreSdsMailbox {
	private static final Logger logger = LoggerFactory.getLogger(RestoreSdsMailbox.class);
	private static final Path BACKUP_PATH = Paths.get("/var/backups/bluemind/sds");
	private CyrusSdsIndexReader sdsIndexReader;
	private Path workingFolder;
	private static final String INDEX_JSON = "index.json";

	public RestoreSdsMailbox(Path jsondir) throws IOException {
		workingFolder = jsondir;
		sdsIndexReader = new CyrusSdsIndexReader(jsondir.resolve(INDEX_JSON));
	}

	public RestoreSdsMailbox() throws IOException {
		this(BACKUP_PATH);
	}

	public CyrusSdsBackupZipMailbox getMailbox(String mailboxUid) throws Exception {
		MailboxIndexJson mailboxIndex = sdsIndexReader.getMailbox(mailboxUid);
		if (mailboxIndex == null) {
			logger.error("Unable to find mailbox uid {} from {}", mailboxUid, workingFolder.resolve(INDEX_JSON));
			return null;
		}
		return new CyrusSdsBackupZipMailbox(mailboxIndex, workingFolder);
	}

	public CyrusSdsBackupMailbox getMailboxFromPreviousBackup(String mailboxUid) throws Exception {
		MailboxIndexJson mailboxIndex = sdsIndexReader.getMailbox(mailboxUid);
		if (mailboxIndex == null) {
			logger.error("Unable to find previous backup mailbox uid {} from {}", mailboxUid,
					workingFolder.resolve(INDEX_JSON));
			return null;
		}
		return new CyrusSdsBackupMailbox(mailboxIndex, workingFolder);
	}

}
