/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.mailbox;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.task.service.IServerTask;
import net.bluemind.dataprotect.api.DataProtectGeneration;
import net.bluemind.dataprotect.api.Restorable;
import net.bluemind.dataprotect.api.RestorableKind;
import net.bluemind.dataprotect.api.RestoreOperation;
import net.bluemind.dataprotect.mailbox.MboxRestoreService.Mode;

public class UserRestoreActionProvider extends AbstractRestoreActionProvider {

	public UserRestoreActionProvider() {
		super(RestorableKind.USER);
	}

	@Override
	public IServerTask getRestoreTask(RestoreOperation op, DataProtectGeneration backup, Restorable item) {
		IServerTask toRun = null;
		switch (op.identifier) {
		case RESTORE_REPLACE_IDENTIFIER:
			toRun = new RestoreBoxTask(backup, item, Mode.REPLACE);
			break;
		case RESTORE_SUBFOLDER_IDENTIFIER:
			toRun = new RestoreBoxTask(backup, item, Mode.SUBFOLDER);
			break;
		default:
			throw new ServerFault("Unsupported op identifier: " + op.identifier);
		}
		return toRun;
	}
}
