/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.calendar.service.internal;

import net.bluemind.calendar.api.VEventSeries;
import net.bluemind.core.auditlogs.AuditLogEntry;
import net.bluemind.core.auditlogs.ILogMapperProvider;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.service.internal.ItemValueAuditLogService;
import net.bluemind.core.rest.BmContext;

public class VEventHistoryAuditService extends ItemValueAuditLogService<VEventSeries> {

	VEventHistoryMapper historyMapper;

	public VEventHistoryAuditService(BmContext ctx, BaseContainerDescriptor cont, ILogMapperProvider<VEventSeries> dm,
			VEventHistoryMapper historyMapper) {
		super(ctx, cont, dm);
		this.historyMapper = historyMapper;
	}

	@Override
	protected void store(AuditLogEntry entry) {
		super.store(entry);
		this.historyMapper.store(entry);
	}

}
