/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */

package net.bluemind.cli.adm.orphans.report;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import net.bluemind.cli.adm.orphans.report.Log.Level;
import net.bluemind.maintenance.checker.report.IReport;
import net.bluemind.maintenance.checker.report.IReportLeaf;

public class DomainsReport extends AbstractReport implements IReport {
	protected List<SystemReport> domainReports;

	public DomainsReport(String title, Level minLevel) {
		super(title, minLevel);
		this.domainReports = new ArrayList<>();
	}

	@Override
	public IReportLeaf addDomainReport(String domainUid) {
		SystemReport reporter = new SystemReport(domainUid, minLevel);
		domainReports.add(reporter);
		return reporter;
	}

	@Override
	public boolean hasWarning() {
		return domainReports.stream().anyMatch(SystemReport::hasWarning);
	}

	@Override
	public boolean hasErrors() {
		return domainReports.stream().anyMatch(SystemReport::hasErrors);
	}

	@Override
	public String toString() {
		List<String> msgs = new ArrayList<>();
		msgs.add(logId);
		domainReports.forEach(report -> msgs.add(report.toString()));
		return msgs.stream().collect(Collectors.joining("\n"));
	}

	public String repairCommand() {
		return domainReports.stream().map(SystemReport::repairCommand).filter(repair -> !repair.isEmpty())
				.collect(Collectors.joining("\n"));
	}

	public String sqlCommand() {
		return domainReports.stream().map(SystemReport::sqlCommand).filter(repair -> !repair.isEmpty())
				.collect(Collectors.joining("\n"));
	}

}
