/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store.factories;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.backend.mail.cql.store.CqlMailboxRecordConversationStore;
import net.bluemind.backend.mail.repository.IMailboxRecordConversationStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.cql.store.CqlContainerStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;

public class RecordConversationFactory extends CqlRepositoryFactory<IMailboxRecordConversationStore>
		implements IContainerBoundFactory<IMailboxRecordConversationStore> {

	@Override
	public Class<IMailboxRecordConversationStore> factoryClass() {
		return IMailboxRecordConversationStore.class;
	}

	@Override
	public IMailboxRecordConversationStore instance(BmContext context, Container container) throws ServerFault {
		CqlSession s = CqlSessions.forKeyspace("core");
		CqlContainerStore store = new CqlContainerStore(s, SequenceStores.getDefault(), context.getSecurityContext());
		return new CqlMailboxRecordConversationStore(s, store, container);
	}

}
