/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.cql.store.factories;

import net.bluemind.backend.mail.cql.store.CqlMailboxReplicaStore;
import net.bluemind.backend.mail.repository.IMailboxReplicaStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.repository.sequences.SequenceStores;

public class MailboxReplicasStoreFactory extends CqlRepositoryFactory<IMailboxReplicaStore>
		implements IContainerBoundFactory<IMailboxReplicaStore> {

	@Override
	public Class<IMailboxReplicaStore> factoryClass() {
		return IMailboxReplicaStore.class;
	}

	@Override
	public IMailboxReplicaStore instance(BmContext context, Container container) throws ServerFault {
		return new CqlMailboxReplicaStore(CqlSessions.forKeyspace("core"), container, SequenceStores.getDefault());
	}

}
