/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.backend.mail.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsDispositionType extends JavaScriptObject {

	protected JsDispositionType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsDispositionType INLINE()
	/*-{
		return "INLINE";
	}-*/;

	public static final native JsDispositionType ATTACHMENT()
	/*-{
		return "ATTACHMENT";
	}-*/;

	public static final JsDispositionType create(net.bluemind.backend.mail.api.DispositionType value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case INLINE:
				return INLINE();
			case ATTACHMENT:
				return ATTACHMENT();
			default:
				return null;
			}
		}
	}
}