/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailboxItemsEndpointPromise implements net.bluemind.backend.mail.api.IMailboxItemsPromise {

	private net.bluemind.backend.mail.api.IMailboxItemsAsync impl;

	public MailboxItemsEndpointPromise(net.bluemind.backend.mail.api.IMailboxItemsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> addFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addFlag(flagUpdate,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> changeset(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<String>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changeset(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> changesetById(Long since  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<Long>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.changesetById(since,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Count> ret = new CompletableFuture<net.bluemind.core.container.api.Count>();
		AsyncHandler<net.bluemind.core.container.api.Count> handler = new AsyncHandler<net.bluemind.core.container.api.Count>() {
			public void success(net.bluemind.core.container.api.Count value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.count(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.backend.mail.api.ImapItemIdentifier> create(net.bluemind.backend.mail.api.MailboxItem value  ) {
		
		CompletableFuture<net.bluemind.backend.mail.api.ImapItemIdentifier> ret = new CompletableFuture<net.bluemind.backend.mail.api.ImapItemIdentifier>();
		AsyncHandler<net.bluemind.backend.mail.api.ImapItemIdentifier> handler = new AsyncHandler<net.bluemind.backend.mail.api.ImapItemIdentifier>() {
			public void success(net.bluemind.backend.mail.api.ImapItemIdentifier value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(value,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id ,  net.bluemind.backend.mail.api.MailboxItem arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createById(id, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteById(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> deleteFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteFlag(flagUpdate,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> expunge() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.expunge( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Stream> fetch(long imapUid ,  String address ,  String encoding ,  String mime ,  String charset ,  String filename  ) {
		
		CompletableFuture<Stream> ret = new CompletableFuture<Stream>();
		AsyncHandler<Stream> handler = new AsyncHandler<Stream>() {
			public void success(Stream value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.fetch(imapUid, address, encoding, mime, charset, filename,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Stream> fetchComplete(long imapUid  ) {
		
		CompletableFuture<Stream> ret = new CompletableFuture<Stream>();
		AsyncHandler<Stream> handler = new AsyncHandler<Stream>() {
			public void success(Stream value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.fetchComplete(imapUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Stream> fetchCompleteByGuid(String guid  ) {
		
		CompletableFuture<Stream> ret = new CompletableFuture<Stream>();
		AsyncHandler<Stream> handler = new AsyncHandler<Stream>() {
			public void success(Stream value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.fetchCompleteByGuid(guid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(Long since ,  net.bluemind.core.container.model.ItemFlagFilter arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> ret = new CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>();
		AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler = new AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>() {
			public void success(net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.filteredChangesetById(since, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> getCompleteById(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCompleteById(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> getForUpdate(long id  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getForUpdate(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Long> getVersion() {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVersion( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(String uid ,  Long arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemChangelog> ret = new CompletableFuture<net.bluemind.core.container.model.ItemChangelog>();
		AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler = new AsyncHandler<net.bluemind.core.container.model.ItemChangelog>() {
			public void success(net.bluemind.core.container.model.ItemChangelog value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.itemChangelog(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<Long>> listItemIdsAfter(net.bluemind.core.api.date.BmDateTime before  ) {
		
		CompletableFuture<List<Long>> ret = new CompletableFuture<List<Long>>();
		AsyncHandler<List<Long>> handler = new AsyncHandler<List<Long>>() {
			public void success(List<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listItemIdsAfter(before,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> multipleDeleteById(List<Long> arg0 ,  Boolean bypassDeletedItems  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleDeleteById(arg0, bypassDeletedItems,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>> multipleGetById(List<Long> arg0  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGetById(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>> multipleUnexpungeById(List<Long> itemIds  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>>() {
			public void success(List<net.bluemind.core.container.model.ItemIdentifier> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleUnexpungeById(itemIds,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<Long>> recentItems(java.util.Date deliveredOrUpdatedAfter  ) {
		
		CompletableFuture<List<Long>> ret = new CompletableFuture<List<Long>>();
		AsyncHandler<List<Long>> handler = new AsyncHandler<List<Long>>() {
			public void success(List<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.recentItems(deliveredOrUpdatedAfter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> removePart(String partId  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.removePart(partId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0  ) {
		
		CompletableFuture<List<Long>> ret = new CompletableFuture<List<Long>>();
		AsyncHandler<List<Long>> handler = new AsyncHandler<List<Long>>() {
			public void success(List<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sortedIds(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.sortedUids(arg0,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> unexpunge(long itemId  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> ret = new CompletableFuture<net.bluemind.core.container.model.ItemIdentifier>();
		AsyncHandler<net.bluemind.core.container.model.ItemIdentifier> handler = new AsyncHandler<net.bluemind.core.container.model.ItemIdentifier>() {
			public void success(net.bluemind.core.container.model.ItemIdentifier value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unexpunge(itemId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<Long>> unreadItems() {
		
		CompletableFuture<List<Long>> ret = new CompletableFuture<List<Long>>();
		AsyncHandler<List<Long>> handler = new AsyncHandler<List<Long>>() {
			public void success(List<Long> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unreadItems( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id ,  net.bluemind.backend.mail.api.MailboxItem arg1  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateById(id, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> uploadPart(Stream part  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.uploadPart(part,  handler);
		return ret;
	}

}
