/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.flags.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class FlagUpdateGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.flags.FlagUpdate> {

	public FlagUpdateGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.flags.FlagUpdate deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.flags.FlagUpdate ret = new net.bluemind.backend.mail.api.flags.FlagUpdate();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.flags.FlagUpdate ret, JSONObject json) {
		JSONValue itemsIdJSON = json.get("itemsId");
		ret.itemsId =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize(itemsIdJSON);
		JSONValue mailboxItemFlagJSON = json.get("mailboxItemFlag");
		ret.mailboxItemFlag =  new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer().deserialize(mailboxItemFlagJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.flags.FlagUpdate ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("itemsId")) {
			JSONValue itemsIdJSON = json.get("itemsId");
			ret.itemsId =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize(itemsIdJSON);
		}
		if (!childPropertiesToIgnore.contains("mailboxItemFlag")) {
			JSONValue mailboxItemFlagJSON = json.get("mailboxItemFlag");
			ret.mailboxItemFlag =  new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer().deserialize(mailboxItemFlagJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.flags.FlagUpdate o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.flags.FlagUpdate o, JSONObject ret) {

		ret.put("itemsId",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( o.itemsId ));
		ret.put("mailboxItemFlag",  new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer().serialize( o.mailboxItemFlag ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.flags.FlagUpdate o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("itemsId")) {
			ret.put("itemsId",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( o.itemsId ));
		}
		if (!childPropertiesToIgnore.contains("mailboxItemFlag")) {
			ret.put("mailboxItemFlag",  new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer().serialize( o.mailboxItemFlag ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}