/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.backend.mail.api.flags.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailboxItemFlagSystem extends JavaScriptObject {

	protected JsMailboxItemFlagSystem() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailboxItemFlagSystem Answered()
	/*-{
		return "Answered";
	}-*/;

	public static final native JsMailboxItemFlagSystem Flagged()
	/*-{
		return "Flagged";
	}-*/;

	public static final native JsMailboxItemFlagSystem Deleted()
	/*-{
		return "Deleted";
	}-*/;

	public static final native JsMailboxItemFlagSystem Draft()
	/*-{
		return "Draft";
	}-*/;

	public static final native JsMailboxItemFlagSystem Seen()
	/*-{
		return "Seen";
	}-*/;

	public static final JsMailboxItemFlagSystem create(net.bluemind.backend.mail.api.flags.MailboxItemFlag.System value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Answered:
				return Answered();
			case Flagged:
				return Flagged();
			case Deleted:
				return Deleted();
			case Draft:
				return Draft();
			case Seen:
				return Seen();
			default:
				return null;
			}
		}
	}
}