package net.bluemind.system.service.hot.internal;

import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.hotupgrade.repository.IHotUpgradeTaskStore;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.service.hot.HotUpgradeExecutableOperation;
import net.bluemind.system.service.hot.HotUpgradeTaskMonitor;

public abstract class HotUpgradeTaskExecutorDbUpdate implements HotUpgradeTaskExecutor {

	private static final Logger logger = LoggerFactory.getLogger(HotUpgradeTaskExecutorDbUpdate.class);

	protected String operationName;
	protected HotUpgradeExecutableOperation operation;
	protected IHotUpgradeTaskStore store;

	protected HotUpgradeTaskExecutorDbUpdate(String operationName, HotUpgradeExecutableOperation operation,
			IHotUpgradeTaskStore store) {
		this.operationName = operationName;
		this.operation = operation;
		this.store = store;
	}

	protected CompletableFuture<Void> executeTask(HotUpgradeTask task, IServerTaskMonitor monitor) {
		return operation.execute(task, new HotUpgradeTaskMonitor(monitor, task)).thenApply(ret -> {
			task.succeed();
			return null;
		}).exceptionally(e -> {
			monitor.log("Fail task " + task + ":\n" + e.getMessage());
			logger.error("[hotupgrade] Fail task {}", task, e);
			task.failed();
			return null;
		}).thenApply((ret) -> {
			try {
				store.updateStatus(task);
			} catch (SQLException e) {
				monitor.log("Unable to update task " + task + ":\n" + e.getMessage());
				logger.error("[hotupgrade] Unable to update task {}", task, e);
			}
			return null;
		});
	}
}
