package net.bluemind.system.service.hot.internal;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import net.bluemind.hotupgrade.repository.IHotUpgradeTaskStore;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.service.hot.HotUpgradeExecutableOperation;
import net.bluemind.system.service.hot.HotUpgradeOperation;

public class HotUpgradeOperationExecutor {
	private Set<HotUpgradeTask> runningTasks;

	public HotUpgradeOperationExecutor(Set<HotUpgradeTask> runningTasks) {
		this.runningTasks = runningTasks;
	}

	public HotUpgradeTaskExecutor get(HotUpgradeOperation operation, IHotUpgradeTaskStore store) {
		return (operation.allowParallelExecution()) //
				? new ParallelHotUpgradeTaskExecutor(operation.name(), executable(operation), store)
				: new SequentialHotUpgradeTaskExecutor(operation.name(), executable(operation), store);
	}

	private HotUpgradeExecutableOperation executable(HotUpgradeOperation operation) {
		return (task, monitor) -> {
			runningTasks.add(task);
			CompletableFuture<Void> execute = operation.execute(task, monitor);
			execute.thenRun(() -> {
				runningTasks.remove(task);
			});
			return execute;
		};
	}

}
