package net.bluemind.system.service.hot;

import net.bluemind.core.rest.BmContext;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;

public interface HotUpgradeOperation extends HotUpgradeExecutableOperation {

	public interface Factory {
		HotUpgradeOperation create(BmContext context);
	}

	String name();

	default boolean handle(String operation) {
		return name().equals(operation);
	}

	boolean allowParallelExecution();

	default long estimatedTime(HotUpgradeTask task) {
		return 0l;
	}
}
