/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.service.internal;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.bluemind.core.rest.BmContext;
import net.bluemind.core.task.service.BlockingServerTask;
import net.bluemind.core.task.service.IServerTask;
import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.dataprotect.api.GenerationContent;
import net.bluemind.dataprotect.api.IDataProtect;
import net.bluemind.dataprotect.api.PartGeneration;
import net.bluemind.dataprotect.service.internal.IDirEntriesWorker.ParGenWorkerRecord;

public class LoadGenerationTask extends BlockingServerTask implements IServerTask {
	private static final Logger logger = LoggerFactory.getLogger(LoadGenerationTask.class);

	private final PartGeneration directory;
	private final List<PartGeneration> parts;
	private BmContext ctx;

	public LoadGenerationTask(BmContext ctx, PartGeneration directory, List<PartGeneration> parts) {
		this.directory = directory;
		this.parts = parts;
		this.ctx = ctx;
	}

	@Override
	public void run(IServerTaskMonitor monitor) throws Exception {
		GenerationContent geneneration = new GenerationContent();
		geneneration.generationId = directory.generationId;
		IDataProtect backupApi = ctx.provider().instance(IDataProtect.class);
		List<String> partTags = parts.stream().map(p -> p.tag).toList();
		geneneration.capabilities = backupApi.getRestoreCapabilitiesByTags(partTags);

		new DirEntriesFactory(new ParGenWorkerRecord(ctx, directory)).loadGenerationContent(geneneration);

		logger.info("Sending generation with {} capabilities", geneneration.capabilities.size());
		monitor.log("Sending generation with {} capabilities", geneneration.capabilities.size());
		monitor.end(true, "restored", JsonUtils.asString(geneneration));
	}

}
