/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.service.internal;

import java.io.File;
import java.util.List;

import net.bluemind.core.rest.BmContext;
import net.bluemind.dataprotect.api.GenerationContent;
import net.bluemind.dataprotect.api.GenerationIndex;
import net.bluemind.dataprotect.api.PartGeneration;

/**
 * Allow to read directory entries from different backup format
 */
public interface IDirEntriesWorker {

	String directoryDataType();

	public void loadContent(String serverIp, GenerationContent geneneration);

	String workFilePath(String serverIp);

	List<File> loadFiles(String path);

	public ParGenWorkerRecord getPartGenRecord();

	public record DirEntries(String version, List<GenerationIndex> entries) {

	}

	public record ParGenWorkerRecord(BmContext ctx, PartGeneration directory) {

	}
}
